import greenfoot.*;  // (World, Actor, GreenfootImage, and Greenfoot)

/**
 * Frog. A frog can move left or right.
 * If a frog catches a fly, it eats it.
 */
public class Frog extends Actor {
    
    private int flysEaten;

    public Frog() {
        flysEaten = 0;
    }

    /**
     * Do whatever the frog likes to to just now.
     */
    public void act() {
        if (foundFly()) {
            eatFly();
            Greenfoot.playSound("slurp.wav"); // Sound "slurp"
        }
        if (Greenfoot.isKeyDown("right")) {
            move(1);
        }
        if (Greenfoot.isKeyDown("left")) {
            move(-1);            
        }
    }
       
    /**
     * Check whether there is a fly in the same cell as we are.
     * Return true, if there is, false otherwise.
     */
    public boolean foundFly() {
        Actor fly = getOneObjectAtOffset(0, 0, Fly.class);
        return fly != null;
    }
    
    /**
     * Eat a fly (if there is one in our cell).
     */
    public void eatFly() {
        Actor fly = getOneObjectAtOffset(0, 0, Fly.class);
        if (fly != null) {
            // eat the fly...
            getWorld().removeObject(fly);
            flysEaten = flysEaten + 1; 
            ((FrogWorld)getWorld()).aktualisierePunkte();
            // and create a new fly...
            Fly newFly = new Fly();
            int x = Greenfoot.getRandomNumber(getWorld().getWidth());
            int y = 0;
            ((FrogWorld)getWorld()).addObject(fly, x, y);
        }
    }
    
    /**
     * Tell how many flys we have eaten.
     */
    public int getFlysEaten() {
        return flysEaten;
    }
    
    /**
     * Set how many flys we have eaten.
     */
    public void setFlysEaten(int newFlysEaten) {
        flysEaten = newFlysEaten;
    }
}
