import greenfoot.*;  // imports Actor, World, Greenfoot, GreenfootImage

/**
 * A world where a frog lives.
 */
public class FrogWorld extends World {
    
    static Frog frog;
    
    /**
     * Create a new world with 9x12 cells and
     * with a cell size of 60x60 pixels.
     */
    public FrogWorld() {
        super(9, 12, 60);        
        setBackground("cell.jpg");
        setPaintOrder(Frog.class, Fly.class);  // draw frog on top of fly
        showText("Punkte: 0", 1, 0);
        prepare();
    }
    
    /**
     * Place a number of leaves into the world at random places.
     * The number of leaves can be specified.
     */
    public void randomFlys(int howMany) {
        for (int i=0; i<howMany; i++) {
            Fly fly = new Fly();
            int x = Greenfoot.getRandomNumber(getWidth());
            int y = 5*i;
            addObject(fly, x, y);
        }
    }

    /**
     * Bereite die Welt für den Programmstart vor.
     * Das heißt: Erzeuge die Anfangs-Objekte und füge sie der Welt hinzu.
     */
    private void prepare() {
        frog = new Frog();
        addObject(frog, 4, 10);
        randomFlys(2);
    }
    
    public void aktualisierePunkte() {
        showText("Punkte: "+ frog.getFlysEaten(), 1, 0);
    }
}